/*
 * Decompiled with CFR 0.152.
 */
import mjs.processing.mobile.mvideo.MVideo;
import processing.core.PClient;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PMIDlet;
import processing.core.PRequest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MYouTubePlayer
extends PMIDlet {
    ImageBrowser imageBrowser;
    VideoLoader videoLoader;
    VideoPlayer videoPlayer;
    PFont font;
    String title;
    String message;
    String foot;
    boolean keyEventConsumed;

    public void setup() {
        this.font = this.loadFont();
        this.textAlign(0);
        this.imageBrowser = new ImageBrowser(this);
        this.videoLoader = new VideoLoader(this);
        this.videoPlayer = new VideoPlayer(this);
    }

    public void draw() {
        this.videoLoader.draw();
        this.imageBrowser.draw();
        this.videoPlayer.draw();
        this.textFont(this.font);
        this.fill(0xFFFFFF);
        this.text(this.title, 0, -60);
        this.text(this.message, 0, 55 + this.font.height);
        this.text(this.foot, 0, 55 + this.font.height * 2);
    }

    public void softkeyPressed(String string) {
        this.videoLoader.softkeyPressed(string);
    }

    public void keyPressed() {
        this.keyEventConsumed = false;
        this.imageBrowser.keyPressed();
        this.videoPlayer.keyPressed();
        this.videoLoader.keyPressed();
    }

    public void libraryEvent(Object object, int n, Object object2) {
        this.imageBrowser.libraryEvent(object, n, object2);
        this.videoLoader.libraryEvent(object, n, object2);
        this.videoPlayer.libraryEvent(object, n, object2);
    }

    private final /* synthetic */ void this() {
        this.title = "MYouTubePlayer";
        this.message = "Ready";
        this.foot = "";
    }

    public MYouTubePlayer() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ImageBrowser {
        PMIDlet pMIDlet;
        PClient imageClient;
        PRequest imageRequest;
        int numImages;
        int loadCounter;
        int currentPage;
        PImage[] images;
        String[] urls;
        int currentImage;
        int x;
        int y;
        int currentX;
        int currentY;
        int imageWidth;
        int imageHeight;
        PImage loadingImage;

        public void draw() {
            int n = 0;
            int n2 = 0;
            if (this.images != null) {
                int n3 = 0;
                while (n3 < this.numImages) {
                    if (this.images[n3] == null) {
                        this.images[n3] = this.loadingImage;
                    }
                    PImage pImage = this.images[n3];
                    n2 = -pImage.height / 2;
                    if (n3 == this.currentImage) {
                        MYouTubePlayer.this.noFill();
                        MYouTubePlayer.this.stroke(0, 255, 0);
                        MYouTubePlayer.this.rect(this.x + n - pImage.width / 2 - 2, this.y + n2 - 2, pImage.width + 4, pImage.height + 4);
                        this.currentX = n;
                    }
                    MYouTubePlayer.this.image(pImage, this.x + n - pImage.width / 2, this.y + n2);
                    n += this.imageWidth + 8;
                    ++n3;
                }
            }
            if (this.x > -this.currentX) {
                this.x -= 5;
            }
            if (this.x < -this.currentX) {
                this.x += 5;
            }
        }

        public void keyPressed() {
            switch (MYouTubePlayer.this.keyCode) {
                case 2: {
                    --this.currentImage;
                    if (this.currentImage >= 0) break;
                    this.currentImage = 0;
                    break;
                }
                case 5: {
                    ++this.currentImage;
                    if (this.currentImage < this.numImages) break;
                    this.currentImage = this.numImages - 1;
                    break;
                }
            }
        }

        public void libraryEvent(Object object, int n, Object object2) {
            if (object == this.imageRequest) {
                if (n == 0) {
                    this.imageRequest.readBytes();
                } else if (n == 1) {
                    this.addImage(MYouTubePlayer.this.loadImage((byte[])object2));
                } else if (n == 2) {
                    MYouTubePlayer.this.message = "Error : " + object2;
                }
            }
        }

        public void addImage(PImage pImage) {
            this.images[this.loadCounter] = pImage;
            ++this.loadCounter;
            if (this.loadCounter != this.numImages) {
                this.downloadImage();
            } else {
                MYouTubePlayer.this.message = "Play Video";
            }
        }

        public void downloadImages(String[] stringArray) {
            this.clear();
            MYouTubePlayer.this.message = "Loading Images ...";
            this.urls = stringArray;
            this.numImages = MYouTubePlayer.this.length(stringArray);
            this.images = new PImage[this.numImages];
            this.downloadImage();
        }

        public void downloadImage() {
            this.downloadImage(this.urls[this.loadCounter]);
        }

        public void downloadImage(String string) {
            int n = string.indexOf(47, 7);
            String string2 = string.substring(7, n);
            String string3 = string.substring(n);
            this.downloadImage(string2, string3);
        }

        public void downloadImage(String string, String string2) {
            this.imageClient = new PClient(this.pMIDlet, string);
            this.imageRequest = this.imageClient.GET(string2);
        }

        public void clear() {
            this.numImages = 0;
            this.currentImage = 0;
            this.loadCounter = 0;
            this.currentX = 0;
            this.x = 0;
            this.currentY = 0;
            this.y = 0;
        }

        private final /* synthetic */ void this() {
            this.currentPage = 1;
            this.currentImage = -1;
            this.imageWidth = 130;
            this.imageHeight = 97;
        }

        ImageBrowser(PMIDlet pMIDlet) {
            this.this();
            this.pMIDlet = pMIDlet;
            this.loadingImage = MYouTubePlayer.this.loadImage("loading.png");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VideoLoader {
        PMIDlet pMIDlet;
        MClient mClient;
        MRequest mRequest;
        MXMLParser mXmlParser;
        boolean warning;
        String server;
        String[] cookies;
        String[] params;
        String[] values;
        boolean videoMark;
        boolean titleMark;
        boolean runtimeMark;
        String videoURL;
        String videoThumb;
        String videoTitle;
        String videoRuntime;
        String searchText;
        Video[] videos;
        int pageVideos;
        int videoCounter;
        PImage youtubeImage;

        public void draw() {
            MYouTubePlayer.this.background(0);
            MYouTubePlayer.this.translate(MYouTubePlayer.this.width / 2, MYouTubePlayer.this.height / 2);
            MYouTubePlayer.this.image(this.youtubeImage, -this.youtubeImage.width / 2, -this.youtubeImage.height / 2);
        }

        public void softkeyPressed(String string) {
            String string2;
            if (string.equals("Search") && (string2 = MYouTubePlayer.this.textInput("Search", this.searchText, 100)) != null) {
                this.searchText = string2;
                this.searchVideos(this.searchText);
            }
        }

        public void keyPressed() {
            if (MYouTubePlayer.this.keyEventConsumed) {
                return;
            }
            switch (MYouTubePlayer.this.keyCode) {
                case 8: {
                    this.playVideo();
                    break;
                }
                case 2: 
                case 5: {
                    this.updateVideoInfo();
                    break;
                }
            }
        }

        public void searchVideos(String string) {
            if (!this.warning) {
                this.values[0] = string;
                MYouTubePlayer.this.message = "Searching ...";
                MYouTubePlayer.this.imageBrowser.clear();
                this.videoCounter = 0;
                MYouTubePlayer.this.foot = "";
                this.videoMark = false;
                this.titleMark = false;
                this.runtimeMark = false;
                this.videoURL = null;
                this.videoTitle = null;
                this.videoThumb = null;
                this.videoRuntime = null;
                this.mRequest = (MRequest)this.mClient.GET("/results", this.params, this.values);
                this.mRequest.cookies(this.cookies);
            } else {
                this.mRequest = (MRequest)this.mClient.GET("/?warned=yes");
                MYouTubePlayer.this.message = "Connecting ...";
            }
        }

        public void libraryEvent(Object object, int n, Object object2) {
            block20: {
                block19: {
                    if (object != this.mRequest) break block19;
                    switch (n) {
                        case 0: {
                            if (this.warning) {
                                this.mRequest.readBytes();
                                break;
                            }
                            this.mXmlParser.start(this.mRequest);
                            break;
                        }
                        case 1: {
                            if (this.warning) {
                                this.cookies = this.mRequest.cookies();
                                this.warning = false;
                                this.searchVideos(this.searchText);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block20;
                }
                if (object == this.mXmlParser) {
                    switch (n) {
                        case 2: {
                            if (object2.equals("div")) {
                                String string = this.mXmlParser.attribute("class");
                                if (string == null) break;
                                if (string.equals("vEntry")) {
                                    if (this.videoMark) {
                                        this.addVideo();
                                    } else {
                                        this.videoMark = true;
                                    }
                                    MYouTubePlayer.this.message = "Found: " + (this.videoCounter + 1);
                                    break;
                                }
                                if (string.equals("vTitle")) {
                                    this.titleMark = true;
                                    break;
                                }
                                if (string.equals("vRuntime")) {
                                    this.runtimeMark = true;
                                    break;
                                }
                                if (!string.equals("pageTitle")) break;
                                this.mXmlParser.stop();
                                this.mRequest.close();
                                this.addVideo();
                                this.loadImages();
                                break;
                            }
                            if (object2.equals("a")) {
                                if (!this.videoMark || this.videoURL != null) break;
                                this.videoURL = this.mXmlParser.attribute("href");
                                break;
                            }
                            if (!object2.equals("img") || !this.videoMark || this.videoThumb != null) break;
                            this.videoThumb = this.mXmlParser.attribute("src");
                            break;
                        }
                        case 4: {
                            if (this.titleMark && this.videoTitle == null) {
                                this.videoTitle = (String)object2;
                                break;
                            }
                            if (!this.runtimeMark || this.videoRuntime != null) break;
                            this.videoRuntime = ((String)object2).trim();
                            break;
                        }
                    }
                }
            }
        }

        public void addVideo() {
            Video video = new Video();
            video.url = this.videoURL;
            video.title = this.videoTitle;
            video.runtime = this.videoRuntime;
            video.thumb = this.videoThumb;
            this.titleMark = false;
            this.runtimeMark = false;
            this.videoURL = null;
            this.videoTitle = null;
            this.videoThumb = null;
            this.videoRuntime = null;
            this.videos[this.videoCounter++] = video;
        }

        public void loadImages() {
            String[] stringArray = new String[this.videoCounter];
            int n = 0;
            while (n < this.videoCounter) {
                stringArray[n] = this.videos[n].thumb;
                ++n;
            }
            MYouTubePlayer.this.imageBrowser.downloadImages(stringArray);
            this.updateVideoInfo();
        }

        public void playVideo() {
            if (MYouTubePlayer.this.imageBrowser.currentImage != -1 && MYouTubePlayer.this.videoPlayer.state == 3) {
                String string = this.videos[MYouTubePlayer.this.imageBrowser.currentImage].url;
                MYouTubePlayer.this.videoPlayer.play(string);
                MYouTubePlayer.this.keyEventConsumed = true;
            }
        }

        public void updateVideoInfo() {
            int n = MYouTubePlayer.this.imageBrowser.currentImage;
            if (n != -1) {
                MYouTubePlayer.this.foot = this.videos[n].title + ' ' + this.videos[n].runtime;
            }
        }

        private final /* synthetic */ void this() {
            this.warning = true;
            this.server = "m.youtube.com";
            this.params = new String[]{"q"};
            this.values = new String[]{" "};
            this.searchText = "";
            this.pageVideos = 10;
        }

        VideoLoader(PMIDlet pMIDlet) {
            this.this();
            this.pMIDlet = pMIDlet;
            MYouTubePlayer.this.softkey("Search");
            this.youtubeImage = MYouTubePlayer.this.loadImage("youtubelogo.png");
            this.mXmlParser = new MXMLParser(pMIDlet);
            this.mClient = new MClient(pMIDlet, this.server);
            this.videos = new Video[this.pageVideos];
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VideoPlayer {
        static final int STARTED = 1;
        static final int END = 2;
        static final int CLOSED = 3;
        PMIDlet pMIDlet;
        int state;
        MVideo mVideo;

        public void draw() {
        }

        public void keyPressed() {
            if (MYouTubePlayer.this.keyEventConsumed) {
                return;
            }
            if (MYouTubePlayer.this.keyCode == 8 && this.state != 3) {
                MYouTubePlayer.this.keyEventConsumed = true;
                this.stop();
            }
        }

        public void libraryEvent(Object object, int n, Object object2) {
            if (object == this.mVideo) {
                switch (n) {
                    case 1: {
                        MYouTubePlayer.this.message = "Playing Video";
                        MYouTubePlayer.this.redraw();
                        break;
                    }
                    case 11: {
                        MYouTubePlayer.this.message = "Buffering ...";
                        MYouTubePlayer.this.redraw();
                        break;
                    }
                    case 12: {
                        MYouTubePlayer.this.message = "";
                        MYouTubePlayer.this.redraw();
                        break;
                    }
                    case 3: {
                        this.state = 2;
                        MYouTubePlayer.this.message = "";
                        MYouTubePlayer.this.redraw();
                        break;
                    }
                    case 2: {
                        MYouTubePlayer.this.message = "";
                        MYouTubePlayer.this.redraw();
                        break;
                    }
                    case 5: {
                        MYouTubePlayer.this.message = "Error: " + object2;
                        MYouTubePlayer.this.redraw();
                        break;
                    }
                }
            }
        }

        public void play(String string) {
            if (this.state == 1) {
                this.stop();
            }
            MYouTubePlayer.this.message = "Loading Video";
            MYouTubePlayer.this.noLoop();
            this.state = 1;
            this.mVideo = new MVideo(this.pMIDlet, string);
            this.mVideo.play();
        }

        public void stop() {
            if (this.mVideo != null) {
                this.mVideo.stop();
                this.mVideo.close();
                this.mVideo = null;
            }
            this.state = 3;
            MYouTubePlayer.this.message = "Play Videos";
            MYouTubePlayer.this.loop();
        }

        private final /* synthetic */ void this() {
            this.state = 3;
        }

        VideoPlayer(PMIDlet pMIDlet) {
            this.this();
            this.pMIDlet = pMIDlet;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Video {
        String url;
        String thumb;
        String title;
        String runtime;

        Video() {
        }
    }
}

